<?php
/**
 * Filename: footer.part.php
 * Created by: Blog Profit Network
 * Copyright:2015 - Blog Profit Network
 *
 * Skype: blogprofitnetwork
 * Email: marcus@blogprofitnetwork.com
 *
 */
defined('_IN_MAIN_MODULE') or die ('ACCESS DENIED');

?>

    <br /><hr />
    <div class="footer">
        <p>
            Copyright &copy; <?php echo (2015 != date('Y') ? '2015 - '. date('Y') : 2015); ?> &middot; <?php echo CLICKVOODOO_NAME .' ('. CLICKVOODOO_VERSION .')'; ?> <br />
            System Developed by Marcus Campbell
        </p>
    </div>
</div>

<script type="text/javascript">
    var clickVoodoo = jQuery.noConflict();
    clickVoodoo(function($) {

        //* header - title
        $('.amd-tracker .title h2').append('<?php echo CLICKVOODOO_NAME; ?>');

        //* tabs
        $('.ui-tabs').tabs({
            active      : $.cookie('activetab'),
            activate    : function(event, ui) {
                $.cookie('activetab', ui.newTab.index(), {
                    expires : 1
                });
            }
        });

        //* dataTables
        $('.amd-tracker #data-tables').dataTable({
            'bJQueryUI'         : true,
            'sPaginationType'   : 'full_numbers',
            'aaSorting'         : [[0, 'desc']]
        });


	    //* add new tracker
	    $('#cmdAddNewTracker').click(function() {
		    $('#holder-manage').slideUp();
		    $('#holder-addnew').slideDown();
	    });

	    //* cancel new tracker
	    $('#cmdCancelNewTracker').click(function() {
		    $('#holder-manage').slideDown();
		    $('#holder-addnew').slideUp();
	    });

	    $('#tracker_url_preview').empty().append($('#tracker_url_value').val());
	    $('#tracker_url_value').keyup(function() {
		    $('#tracker_url_preview').empty().append($(this).val());
	    });

	    //* generate url value
	    $('#cmdGenerateUrlValue').click(function() {
		    var $this = $(this);
		    var $value = $('#tracker_url_value');

		    $this.children('span.mif-loop2').addClass('mif-ani-spin');
		    $value.val('').prop('disabled', 'disabled').prop('placeholder', 'Generating new URL value... Please wait!');


		    var $data = {
			    action : 'amdtracker_generate_url'
		    }
		    $.post('<?php echo admin_url('admin-ajax.php'); ?>', $data, function(res) {
			    $('#cmdGenerateUrlValue').children('span.mif-loop2').removeClass('mif-ani-spin');
			    $('#tracker_url_value').prop('disabled', false).prop('placeholder', '').val(res);
			    $('#tracker_url_preview').empty().append($('#tracker_url_value').val());
		    });
		    return false;
	    });

	    $('#cmdSubmitNewTracker').click(function() {

		    var $id     = $('#tracker_id');
			var $name   = $('#tracker_name');
		    var $url    = $('#tracker_url');
		    var $value  = $('#tracker_url_value');
		    var $dialog = $('#dialog');

		    var $data = {
			    action  : 'amdtracker_add_tracker',
			    name    : $name.val(),
			    url     : $url.val(),
			    value   : $value.val()
		    }


		    //* validation
		    if ($name.val() == '') {
			    $name.focus().closest('div').addClass('error');
			    return false;
		    }
		    else {
			    $name.closest('div').removeClass('error');
		    }

		    if ($url.val() == '') {
			    $url.focus().closest('div').addClass('error');
			    return false;
		    }
		    else {
			    $url.closest('div').removeClass('error');
		    }

		    if ($value.val() == '') {
			    $value.focus().closest('div').addClass('error');
			    return false;
		    }
		    else {
			    $value.closest('div').removeClass('error');
		    }


		    //* submit
		    $dialog.empty().removeClass('ui-state-error').addClass('ui-state-highlight').append('Submitting data... Please wait!');
		    $.post('<?php echo admin_url('admin-ajax.php'); ?>', {
			    action  : 'amdtracker_validate_value',
			    value   : $value.val()
		    }, function(validation_response) {
			    if (validation_response == 'found') {
				    $dialog.empty().removeClass('ui-state-highlight').addClass('ui-state-error').append('Shortened URL value exist. Please generate or replace.');
			    }

			    if (validation_response == 'error') {
				    $dialog.empty().removeClass('ui-state-highlight').addClass('ui-state-error').append('Data cannot be processed. Please try again!');
			    }

			    if (validation_response == 'cleared') {
				    $.post('<?php echo admin_url('admin-ajax.php'); ?>', $data, function(res) {
					    if (res != 'done') {
						    $dialog.empty().removeClass('ui-state-hight').addClass('ui-state-error').append('Data cannot be processed. Please try again!');
					    }
					    else {
						    $dialog.empty().removeClass('iu-state-error').addClass('ui-state-highlight').append('Data has been successfully submitted.');
						    window.location.href = '<?php echo admin_url('admin.php?page='. CLICKVOODOO_CODE) ?>';
					    }
				    });
			    }


		    });

		    return false;
	    });


	    //* delete
	    $('*[id^=cmdDelete]').click(function() {
		    var q = confirm('Are you sure you want to delete this item?');
		    if (q) {
			    var $data = {
				    action  : 'amdtracker_delete_tracker',
				    id      : $(this).attr('rel')
			    }
			    $.post('<?php echo admin_url('admin-ajax.php'); ?>', $data);
			    $(this).closest('tr').fadeOut();
		    }
	    });


	    //* update status
	    $('*[id^=cmdStatus]').click(function() {
		    var $this = $(this);
		    var $span = $this.children('span');

		    var $data = {
			    action  : 'amdtracker_update_status',
			    id      : $this.attr('rel')
		    }
		    $.post('<?php echo admin_url('admin-ajax.php') ?>', $data);

		    if ($span.hasClass('fg-green')) {
			    $span.removeClass('fg-green').addClass('fg-red');
		    }
		    else {
			    $span.removeClass('fg-red').addClass('fg-green');
		    }
	    });


	    //* reset stats
	    $('*[id^=cmdResetStats]').click(function() {
		    var q = confirm('Are you sure you want to reset the stats for this item?');
		    if (q) {
			    var $data = {
				    action  : 'amdtracker_reset_stats',
				    id      : $(this).attr('rel')
			    }
			    $.post('<?php echo admin_url('admin-ajax.php'); ?>', $data);
			    $('#clicks_'+ $(this).attr('rel')).text(0);
		    }
	    });


	    //* expand details
	    $('*[id^=cmdExpandDetails]').click(function() {
		    var $this = $(this);
		    var $span = $(this).children('span');
		    var $holder = $('#holder-details-'+ $this.attr('rel'));

		    if ($span.hasClass('mif-unfold-more')) {
			    $holder.slideDown();
			    $span.removeClass('mif-unfold-more').addClass('mif-unfold-less');
		    }
		    else {
			    $holder.slideUp();
			    $span.removeClass('mif-unfold-less').addClass('mif-unfold-more');
		    }
	    });


	    //* copy link
	    var copy = new ZeroClipboard($('*[id^=cmdCopy]'));
	    copy.on('ready', function(readyEvent) {
	        copy.on('aftercopy', function(event) {
		        event.target.innerHTML = 'Copied!';
		        setTimeout(function() {
			        event.target.innerHTML = '<span class="icon mif-files-empty"></span>';
		        }, 1000);
		    });
	    });


	    //* reload value
	    $('*[id^=cmdReloadUrlValue]').click(function() {
			var $this = $(this);

		    $('#tracker_url_value').val($this.data('reloadValue'));
		    $('#tracker_url_preview').empty().append($('#tracker_url_value').val());

		    return false;
	    });


	    //* submit changes
		$('#cmdUpdateTracker').click(function() {
			var $id     = $('#tracker_id');
			var $name   = $('#tracker_name');
		    var $url    = $('#tracker_url');
		    var $value  = $('#tracker_url_value');
		    var $dialog = $('#dialog');

		    var $data = {
			    action  : 'amdtracker_update_tracker',
			    id      : $id.val(),
			    name    : $name.val(),
			    url     : $url.val(),
			    value   : $value.val()
		    }


		    //* validation
		    if ($name.val() == '') {
			    $name.focus().closest('div').addClass('error');
			    return false;
		    }
		    else {
			    $name.closest('div').removeClass('error');
		    }

		    if ($url.val() == '') {
			    $url.focus().closest('div').addClass('error');
			    return false;
		    }
		    else {
			    $url.closest('div').removeClass('error');
		    }

		    if ($value.val() == '') {
			    $value.focus().closest('div').addClass('error');
			    return false;
		    }
		    else {
			    $value.closest('div').removeClass('error');
		    }

		    //* submit
		    $dialog.empty().removeClass('ui-state-error').addClass('ui-state-highlight').append('Submitting data... Please wait!');
			$.post('<?php echo admin_url('admin-ajax.php'); ?>', {
				action  : 'amdtracker_validate_existing_value',
				id      : $id.val(),
				value   : $value.val()
			}, function(validation_response) {
				if (validation_response == 'found') {
				    $dialog.empty().removeClass('ui-state-highlight').addClass('ui-state-error').append('Shortened URL value exist. Please generate or replace.');
			    }

			    if (validation_response == 'error') {
				    $dialog.empty().removeClass('ui-state-highlight').addClass('ui-state-error').append('Data cannot be processed. Please try again!');
			    }

			    if (validation_response == 'cleared') {
				    $.post('<?php echo admin_url('admin-ajax.php'); ?>', $data, function(res) {
					    if (res != 'done') {
						    $dialog.empty().removeClass('ui-state-hight').addClass('ui-state-error').append('Data cannot be processed. Please try again!');
					    }
					    else {
						    $dialog.empty().removeClass('iu-state-error').addClass('ui-state-highlight').append('Data has been successfully submitted.');
						    window.location.href = '<?php echo admin_url('admin.php?page='. CLICKVOODOO_CODE) ?>';
					    }
				    });
			    }
			});

			return false;
		});


	    $('#settings_url_parser').keyup(function() {
		    $('#settings_url_parser_preview').empty().append($(this).val());
	    });

	    //* settings
	    $('#cmdSubmitSettings').click(function() {
		    var $url_parser = $('#settings_url_parser');
		    var $dialog = $('#settings-dialog');

		    var $data = {
			    action      : 'amdtracker_update_settings',
			    url_parser  : $url_parser.val()
		    }

		    //* validation
		    if ($url_parser.val() == '') {
			    $url_parser.focus().closest('div').addClass('error');
			    return false;
		    }
		    else {
			    $url_parser.closest('div').removeClass('error');
		    }

		    //* submit
		    $dialog.empty().removeClass('ui-state-error').addClass('ui-state-highlight').append('Submitting data... Please wait!');
		    $.post('<?php echo admin_url('admin-ajax.php'); ?>', $data, function(res) {
			    if (res != 'done') {
				    $dialog.empty().removeClass('ui-state-highlight').addClass('ui-state-error').append('Data cannot be processed. Please try again!');
			    }
			    else {
				    $dialog.empty().removeClass('ui-state-error').addClass('ui-state-highlight').append('Data has been successfully submitted.');
				    window.location.href = '<?php echo admin_url('admin.php?page='. CLICKVOODOO_CODE); ?>';
			    }
		    });

		    return false;
	    });
    });
</script>
