<?php
/**
 * Filename: manage.php
 * Created by: Blog Profit Network
 * Copyright:2015 - Blog Profit Network
 *
 * Skype: blogprofitnetwork
 * Email: marcus@blogprofitnetwork.com
 *
 */
defined('_IN_MAIN_MODULE') or die ('ACCESS DENIED');

include_once ('pages/header.part.php');

$trackerUrls = $clickVoodooDatabase->getAllTrackerUrls();
?>



    <div class="ui-tabs">
        <ul class="ui-tabs-nav">
            <li><a href="#introduction">Introduction</a></li>
            <li><a href="#manage">Manage</a></li>
	        <li><a href="#settings">Settings</a></li>
        </ul>


        <!-- introduction -->
        <div id="introduction">
            <?php // include_once ('pages/intro.part.php'); ?>
        </div>
        <!-- // introduction -->


	    <!-- manage -->
	    <div id="manage" class="grid">
		    <!-- holder - manage -->
		    <div id="holder-manage" class="row cell">
			    <div>
				    <h2>
					    Manage <?php echo CLICKVOODOO_NAME; ?>
					    <span style="float:right;">
						    <a href="javascript:void(0);" name="cmdAddNewTracker" id="cmdAddNewTracker" class="button button-primary">
							    <span class="icon mif-plus"></span>
						    </a>
					    </span>
				    </h2> <hr /> <br />

				    <div>
					    <table id="data-tables" class="table hovered striped">
						    <thead>
						        <tr>
							        <th width="50" style="text-align:center;">ID</th>
							        <th width="350">Name</th>
							        <th width="100" style="text-align:center;">Clicks</th>
							        <th width="150" style="text-align:center;">Actions</th>
						        </tr>
						    </thead>

						    <?php
						    if (0 != count($trackerUrls)) {
							    echo '<tbody>';
							        foreach ($trackerUrls as $trackerUrl) {
								        $trackerUrlId = $trackerUrl['id'];

								        if (get_option('permalink_structure')) {
									        $permalink_structure = array(
										        'root'  => get_bloginfo('home') .'/'. $trackerUrl['url_value'] .'/',
										        'ext'   => get_bloginfo('home') .'/'. $options['url_parser'] .'/'. $trackerUrl['url_value'] .'/'
									        );
								        }
								        else {
									        $permalink_structure = array(
										        'root'  => get_bloginfo('home') .'?'. $trackerUrl['url_value'],
										        'ext'   => get_bloginfo('home') .'?'. $options['url_parser'] .'='. $trackerUrl['url_value']
									        );
								        }
								        ?>

								        <tr>
									        <td align="center"><?php echo $trackerUrl['id']; ?></td>
									        <td>
										        <?php echo $trackerUrl['name']; ?>

										        <div id="holder-details-<?php echo $trackerUrlId; ?>" class="ui-state-default" style="display:none; font-size:12px;">
											        <table width="100%">
												        <thead>
												            <th colspan="2">Details</th>
												        </thead>
												        <tbody>
												            <tr>
													            <td><strong>Shortened URL 1</strong></td>
													            <td>
														            <?php echo $permalink_structure['root']; ?>
														            <span style="float:right;">
															            <button name="cmdCopy" id="cmdCopy" rel="<?php echo $trackerUrlId; ?>" data-clipboard-text="<?php echo $permalink_structure['root']; ?>" class="button button-secondary" title="Copy link">
																            <span class="icon mif-files-empty"></span>
															            </button>
														            </span>
													            </td>
												            </tr>
												            <tr>
													            <td><strong>Shortened URL 2</strong></td>
													            <td>
														            <?php echo $permalink_structure['ext']; ?>
														            <span style="float:right;">
															            <button name="cmdCopy" id="cmdCopy" rel="<?php echo $trackerUrlId; ?>" data-clipboard-text="<?php echo $permalink_structure['ext']; ?>" class="button button-secondary" title="Copy link">
																            <span class="icon mif-files-empty"></span>
															            </button>
														            </span>
													            </td>
												            </tr>
												            <tr>
													            <td><strong>Original URL</strong></td>
													            <td><?php echo $trackerUrl['url']; ?></td>
												            </tr>
												        </tbody>
											        </table>
										        </div>
									        </td>
									        <td align="center">
										        <span id="clicks_<?php echo $trackerUrlId; ?>"><?php echo $trackerUrl['clicks']; ?></span>
									        </td>
									        <td align="center">
										        <a href="javascript:void(0);" name="cmdResetStats" id="cmdResetStats" rel="<?php echo $trackerUrlId; ?>" class="button button-secondary fg-red" title="Reset stats for <?php echo $trackerUrl['name']; ?>"><span class="icon mif-loop2"></span></a>
										        <a href="javascript:void(0);" name="cmdExpandDetails" id="cmdExpandDetails" rel="<?php echo $trackerUrlId; ?>" class="button button-secondary" title="Expand details"><span class="icon mif-unfold-more"></span></a>
										        <a href="javascript:void(0);" name="cmdStatus" id="cmdStatus" rel="<?php echo $trackerUrlId; ?>" class="button button-secondary" title="Toggle visibility"><span class="icon mif-eye <?php echo ($trackerUrl['status'] == CLICKVOODOO_ENABLED) ? 'fg-green' : 'fg-red'; ?>"></span></a>
										        <a href="<?php echo admin_url('admin.php?page=' . CLICKVOODOO_CODE . '&action=edit&id=' . $trackerUrlId); ?>" class="button button-secondary" title="Edit <?php echo $trackerUrl['name']; ?>"><span class="icon mif-pencil"></span></a>
										        <a href="javascript:void(0);" name="cmdDelete" id="cmdDelete" rel="<?php echo $trackerUrlId; ?>" class="button button-secondary" title="Delete <?php echo $trackerUrl['name']; ?>"><span class="icon mif-cancel fg-red"></span></a>
									        </td>
								        </tr>

								        <?php
							        }
							    echo '</tbody>';
						    }
						    ?>
					    </table>
				    </div>
			    </div>
		    </div>
		    <!-- // holder - manage -->


		    <!-- holder - addnew -->
		    <div id="holder-addnew" class="row cell" style="display:none;">
			    <div>
				    <h2>Add New</h2> <hr /><br />

				    <div>
					    <form name="addNewTrackerForm" id="addNewTrackerForm" method="POST" action="">
						    <div class="row cells2">
							    <div class="cell">
								    <div class="input-control text full-size">
									    <label for="tracker_name">Name</label>
									    <input type="text" name="tracker_name" id="tracker_name" placeholder="Enter name ( reference only )" value="" />
								    </div>
							    </div>
						    </div>

						    <div class="row cells2">
							    <div class="cell">
								    <div class="input-control text full-size">
									    <label for="tracker_url">URL To Shorten</label>
									    <input type="text" name="tracker_url" id="tracker_url" placeholder="Enter URL you want to shorten" value="" />
								    </div>
							    </div>

							    <div class="cell">
								    <div class="row cells12">
									    <div class="cell colspan10">
										    <div class="input-control text full-size">
										        <label for="tracker_url_value">Shortened URL</label>
										        <input type="text" name="tracker_url_value" id="tracker_url_value" value="<?php echo $clickVoodooHelpers->generateRandomChars(); ?>" />
									        </div>
									    </div>
									    <div class="cell colspan2">
										    <div style="margin-top:10px;"></div>
										    <button name="cmdGenerateUrlValue" id="cmdGenerateUrlValue" class="button button-secondary fg-red">
											    <span class="mif-loop2"></span>
										    </button>
									    </div>
								    </div>
							    </div>
						    </div>

						    <div class="row cell">
							     <div style="background:#f1f1f1; padding:10px;">
<!--								     <strong>Preview URL : </strong> --><?php //echo get_bloginfo('home') .'?'. $options['url_parser'] .'='; ?><!--<span id="tracker_url_preview"></span>-->

								     <?php
								     if (get_option('permalink_structure')) {
									     //* enabled
									     echo '<strong>Generated URL : </strong> '. get_bloginfo('home') .'/'. $options['url_parser'] .'/<span id="tracker_url_preview"></span>/';
								     }
								     else {
									     //* disabled
									     echo '<strong>Generated URL : </strong> '. get_bloginfo('home') .'?'. $options['url_parser'] .'=<span id="tracker_url_preview"></span>';
								     }
								     ?>
							     </div>
						    </div>

						    <div class="row cell">
							    <button name="cmdSubmitNewTracker" id="cmdSubmitNewTracker" class="button button-primary">
								    <span class="icon mif-checkmark"></span> Submit
							    </button>
							    <a href="javascript:void(0);" name="cmdCancelNewTracker" id="cmdCancelNewTracker" class="button button-secondary fg-red">
							        <span class="icon mif-cross"></span> Cancel
						        </a>

							    <span id="dialog"></span>
						    </div>
					    </form>
				    </div>
			    </div>
		    </div>
		    <!-- // holder - addnew -->
	    </div>
	    <!-- // manage -->


	    <!-- settings -->
		<div id="settings" class="grid">
			<div class="row cell">
				<div>
					<h2>Settings</h2> <hr /><br />

					<div>
						<form name="settingsForm" id="settingsForm" method="POST" action="">
							<div class="row cells2">
								<div class="cell">
									<div class="input-control text full-size">
										<label for="settings_url_parser">Url Parser</label>
										<input type="text" name="settings_url_parser" id="settings_url_parser" placeholder="Enter URL parser." value="<?php echo $options['url_parser']; ?>" />
									</div>
								</div>
							</div>

							<div class="row cell">
							     <div style="background:#f1f1f1; padding:10px;">
								     <strong>Preview : </strong>
<!--								     --><?php //echo get_bloginfo('home') .'?'; ?><!--<span id="settings_url_parser_preview">--><?php //echo $options['url_parser']; ?><!--</span>=yahoo-->

								     <?php
								     if (get_option('permalink_structure')) {
									     echo get_bloginfo('home') .'/<span id="settings_url_parser_preview">'. $options['url_parser'] .'</span>/yahoo/';
								     }
								     else {
									     echo get_bloginfo('home') .'?<span id="settings_url_parser_preview">'. $options['url_parser'] .'</span>=yahoo';
								     }
								     ?>
							     </div>
						    </div>

							<div class="row cell">
							    <button name="cmdSubmitSettings" id="cmdSubmitSettings" class="button button-primary">
								    <span class="icon mif-checkmark"></span> Submit Settings
							    </button>

							    <span id="settings-dialog"></span>
						    </div>
						</form>
					</div>
				</div>
			</div>
		</div>
	    <!-- // settings -->
	</div>

<?php
include_once ('pages/footer.part.php');
