<?php
/**
 * Plugin Name: Click Voodoo
 * Plugin URI: http://blogprofitnetwork.com
 * Description: Affiliate Marketing Dude Tracker is an awesome tool created by Marcus Campbell.
 * Version: 2.0.4
 * Author: Blog Profit Network
 * AuthorU URI: http://blogprofitnetwork.com
 *
 *
 *
 * Filename: amd-tracker.php
 * Created by: Blog Profit Network
 * Copyright:2015 - Blog Profit Network
 *
 * Skype: blogprofitnetwork
 * Email: marcus@blogprofitnetwork.com
 *
 */
define ('_IN_MAIN_MODULE', 1);

include_once ('config.local.php');
include_once ('lib/_database.php');
include_once ('lib/_pages.php');
include_once ('lib/_metaboxes.php');
include_once ('lib/_shortcodes.php');
include_once ('lib/_widgets.php');
include_once ('lib/_helpers.php');
include_once ('lib/_init.php');

//* init variables
$clickVoodooDatabase = new clickVoodooDatabase();
$clickVoodooHelpers  = new clickVoodooHelpers();

//* hooks for table installation / uninstallation
register_activation_hook(__FILE__, array($clickVoodooDatabase, 'install'));
register_deactivation_hook(__FILE__, array($clickVoodooDatabase, 'uninstall'));

//* ajax requests
add_action('wp_ajax_amdtracker_generate_url', array($clickVoodooHelpers, 'generateRandomChars'));
add_action('wp_ajax_amdtracker_add_tracker', array($clickVoodooDatabase, 'addTracker'));
add_action('wp_ajax_amdtracker_delete_tracker', array($clickVoodooDatabase, 'deleteTracker'));
add_action('wp_ajax_amdtracker_update_status', array($clickVoodooDatabase, 'updateStatus'));
add_action('wp_ajax_amdtracker_reset_stats', array($clickVoodooDatabase, 'resetClicks'));
add_action('wp_ajax_amdtracker_update_tracker', array($clickVoodooDatabase, 'updateTracker'));
add_action('wp_ajax_amdtracker_update_settings', array($clickVoodooDatabase, 'updateSettings'));

add_action('wp_ajax_amdtracker_validate_value', array($clickVoodooDatabase, 'validateTracker'));
add_action('wp_ajax_amdtracker_validate_existing_value', array($clickVoodooDatabase, 'validateExistingTracker'));



//* rewrite url
add_action('init', 'amdAddRewriteRules');
function amdAddRewriteRules() {
	if (is_admin()) {
		global  $wp_rewrite,
				$clickVoodooDatabase;

		$option = get_option($clickVoodooDatabase->tableOptions);
		$parser = $option['url_parser'];

		add_rewrite_rule('^'. $parser .'/([^/]*)/?', 'index.php?'. $parser .'=$matches[1]', 'top');
		$wp_rewrite->flush_rules(true);
	}
}


//* parse the url... custom and odd way :)
add_action('init', 'amdQueryUrl');
function amdQueryUrl() {
	if (!is_admin()) {
		global $clickVoodooDatabase;

		$option = get_option($clickVoodooDatabase->tableOptions);
		$parser = $option['url_parser'];

		if (get_option('permalink_structure')) {
			//* pretty url
			$url = preg_split('@/@', $_SERVER['REQUEST_URI'], NULL, PREG_SPLIT_NO_EMPTY);
//			if (0 != count($url)) {
//				if ($parser == $url[0]) {
//					$value = trim(strip_tags($url[1]));
//				}
//			}

			if (0 != count($url)) {
				if (count($url) > 1) {
					if ($parser == $url[0]) {
						$value = trim(strip_tags($url[1]));
					}
				}
				else {
					$value = trim(strip_tags($url[0]));
				}
			}

		}
		else {
			//* ugly url
//			$value = trim(strip_tags($_GET[$parser]));


			if (0 != count($_GET)) {
				if (!empty(trim(strip_tags($_GET[$parser])))) {
					$value = trim(strip_tags($_GET[$parser]));
				}
				else {
					foreach ($_GET as $k => $v) {
						$value = trim(strip_tags($k));
					}
				}
			}
		}

		if (0 != count($value)) {
			$tracker = $clickVoodooDatabase->getTrackerByValue($value);
			if (0 != count($tracker)) {
				if ($tracker['status'] == CLICKVOODOO_ENABLED) {
					$id = $tracker['id'];
					$clicks = $tracker['clicks'] + 1;

					$clickVoodooDatabase->updateClicksById($id, $clicks);
				}?>

				<script type="text/javascript">
					window.location.href = '<?php echo $tracker['url']; ?>';
				</script>

				<?php
			}
		}
	}
}