<?php
/**
 * Filename: _database.php
 * Created by: Blog Profit Network
 * Copyright:2015 - Blog Profit Network
 *
 * Skype: blogprofitnetwork
 * Email: marcus@blogprofitnetwork.com
 *
 */
defined('_IN_MAIN_MODULE') or die ('ACCESS DENIED');

class clickVoodooDatabase {
    var $db;
    var $dbPrefix;

    var $tableName;
    var $tableCollation;

	var $tableUrls;
	var $tableUrlsVersion;

    var $tableOptions;
    var $tableOptionsDefaults;

    function __construct() {
        global $wpdb;

        $this->db                   = $wpdb;
        $this->dbPrefix             = $this->db->prefix;

        $this->tableName            = $this->dbPrefix .'cv';
        $this->tableCollation       = $this->db->get_charset_collate();

	    $this->tableUrls            = $this->tableName .'_urls';
	    $this->tableUrlsVersion     = '1.0.0';

        $this->tableOptions         = $this->tableName .'_options';
        $this->tableOptionsDefaults = array(
	        'url_parser'    => 't'
        );
    }

    function execTable($table) {
        include_once (ABSPATH .'/wp-admin/includes/upgrade.php');
        dbDelta($table);
    }

    function install() {
	    $this->_installTableUrls();
        $this->_installTableOptions();
    }

		function _installTableUrls() {
			$version = get_option($this->tableUrls);
			if ($version != $this->tableUrlsVersion) {
				if ($this->db->get_var('SHOW TABLES LIKE "'. $this->tableUrls .'_backup"') == $this->tableUrls .'_backup') {
					$q = 'CREATE TABLE `'. $this->tableUrls .'_backup_2` LIKE `'. $this->tableUrls .'_backup`';
					$this->db->query($q);

					$q2 = 'INSERT INTO `'. $this->tableUrls .'_backup_2` SELECT * FROM `'. $this->tableUrls .'_backup`';
					$this->db->query($q2);

					$q3 = 'DROP TABLE `'. $this->tableUrls .'_backup`';
					$this->db->query($q3);
				}

				if ($this->tableUrlsVersion == '1.0.0') {
					$table = 'CREATE TABLE `'. $this->tableUrls .'` (
						`id`            INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
						`name`          VARCHAR(255) NOT NULL,

						`url`           VARCHAR(512) NOT NULL,
						`url_value`     VARCHAR(512) NOT NULL,

						`clicks`        INT(5) NOT NULL DEFAULT 0,

						`created`       DATETIME DEFAULT "0000-00-00 00:00:00",
						`modified`      DATETIME DEFAULT "0000-00-00 00:00:00",
						`ip`            VARCHAR(255) NOT NULL DEFAULT "127.0.0.1",
						`status`        INT(5) NOT NULL DEFAULT 1
					) '. $this->tableCollation;
				}
				$this->execTable($table);

				if ($this->db->get_var('SHOW TABLES LIKE "'. $this->tableUrls .'_backup_2"') == $this->tableUrls .'_backup_2') {
                    $q = 'SELECT * FROM `'. $this->tableUrls .'_backup_2`';
                    $res = $this->db->get_results($q, ARRAY_A);
                    if (0 != count($res)) {
                        foreach ($res as $data) {
                            if ($version == '1.0.0') {
                                $q2 = 'INSERT INTO `'. $this->tableUrls .'` (
                                    `id`, `name`, `url`, `url_value`, `clicks`, `created`, `modified`, `ip`, `status`
                                ) VALUES (
                                    "'. $data['id'] .'", "'. $data['name'] .'", "'. $data['url'] .'", "'. $data['url_value'] .'", "'. $data['clicks'] .'", "'. $data['created'] .'", "'. $data['modified'] .'", "'. $data['ip'] .'", "'. $data['status'] .'"
                                )';
                            }
                            $this->db->query($q2);
                        }
                    }

                    $q3 = 'DROP TABLE `'. $this->tableUrls .'_backup_2`';
                    $this->db->query($q3);
                }
			}
			else {
				if ($this->db->get_var('SHOW TABLES LIKE "'. $this->tableUrls .'_backup"') == $this->tableUrls .'_backup') {
					$q = 'CREATE TABLE `'. $this->tableUrls .'` LIKE `'. $this->tableUrls .'_backup`';
					$this->db->query($q);

					$q2 = 'INSERT INTO `'. $this->tableUrls .'` SELECT * FROM `'. $this->tableUrls .'_backup`';
					$this->db->query($q2);

					$q3 = 'DROP TABLE `'. $this->tableUrls .'_backup`';
					$this->db->query($q3);
				}
			}
			update_option($this->tableUrls, $this->tableUrlsVersion);
		}

        function _installTableOptions() {
            $options = get_option($this->tableOptions);
            if (is_array($options) || !is_array($options)) :
                update_option($this->tableOptions, $this->tableOptionsDefaults);
            endif;
        }

    function uninstall() {
        $this->_uninstallTableOptions();
    }

		function _uninstallTableUrls() {
			if ($this->db->get_var('SHOW TABLES LIKE "'. $this->tableUrls .'_backup"') != $this->tableUrls .'_backup') {
				$q = 'CREATE TABLE `'. $this->tableUrls .'_backup` LIKE `'. $this->tableUrls .'`';
				$this->db->query($q);

				$q2 = 'INSERT INTO `'. $this->tableUrls .'_backup` SELECT * FROM `'. $this->tableUrls .'`';
				$this->db->query($q2);

				$q3 = 'DROP TABLE `'. $this->tableUrls .'`';
				$this->db->query($q3);
			}
		}

        function _uninstallTableOptions() {
            $options = get_option($this->tableOptions);
            if (is_array($options) || !is_array($options)) :
                delete_option($this->tableOptions);
            endif;
        }



	function checkUrlValue($value) {
		$q = 'SELECT `id` FROM `'. $this->tableUrls .'` WHERE `url_value`="'. $value .'" LIMIT 1';
		return $this->db->get_row($q, ARRAY_A);
	}

	function addTracker() {
		global $clickVoodooHelpers;

		if ($_POST) {
			//* do final checking here for the generated value before saving to db.
			//* if found a match, just generate a new one and save that into db.

			$name       = trim(strip_tags($_POST['name']));
			$url        = trim(strip_tags($_POST['url']));
			$value      = trim(strip_tags($_POST['value']));

			$clicks     = 0;
			$created    = strftime('%Y-%m-%d %T');
			$modified   = strftime('%Y-%m-%d %T');
			$ip         = $_SERVER['REMOTE_ADDR'];
			$status     = CLICKVOODOO_ENABLED;

			$q = 'INSERT INTO `'. $this->tableUrls .'` (`id`, `name`, `url`, `url_value`, `clicks`, `created`, `modified`, `ip` ,`status`) VALUES (NULL, "'. $name .'", "'. $url .'", "'. $value .'", "'. $clicks .'", "'. $created .'", "'. $modified .'", "'. $ip .'", "'. $status .'")';
			$this->db->query($q);
			$id = $this->db->insert_id;


			/**
			 * now, create page and post version of this
			 * use the following reference
			 * GUID : store the $id of the tracker
			 * POST_STATUS : CLICKVOODOO_CODE
			 */

			$postid = wp_insert_post(array(
				'post_title'        => $name .' - created automatically by '. CLICKVOODOO_NAME .' : DO NOT DELETE',
				'post_name'         => $value,
				'post_content'      => '',
				'post_author'       => 0,
				'post_type'         => 'post',
				'post_status'       => 'auto-draft',
				'ping_status'       => 'closed',
				'comment_status'    => 'closed'
			));
			if ($postid) {
				$q = 'UPDATE `'. $this->dbPrefix .'posts` SET `guid`='. intval($id) .' WHERE `ID`='. intval($postid);
				$this->db->query($q);
			}


			$pageid = wp_insert_post(array(
				'post_title'        => $name .' - created automatically by '. CLICKVOODOO_NAME .' : DO NOT DELETE',
				'post_name'         => $value,
				'post_content'      => '',
				'post_author'       => 0,
				'post_type'         => 'page',
				'post_status'       => 'auto-draft',
				'ping_status'       => 'closed',
				'comment_status'    => 'closed'
			));
			if ($pageid) {
				$q = 'UPDATE `'. $this->dbPrefix .'posts` SET `guid`='. intval($id) .' WHERE `ID`='. intval($pageid);
				$this->db->query($q);
			}


			die ('done');
		}
		die ('error');
	}

	function getAllTrackerUrls() {
		$q = 'SELECT * FROM `'. $this->tableUrls .'` ORDER BY `id` DESC';
		return $this->db->get_results($q, ARRAY_A);
	}

	function getTrackerById($id) {
		$q = 'SELECT * FROM `'. $this->tableUrls .'` WHERE `id`='. intval($id);
		return $this->db->get_row($q, ARRAY_A);
	}

	function getTrackerByValue($value) {
		$q = 'SELECT * FROM `'. $this->tableUrls .'` WHERE `url_value`="'. $value .'"';
		return $this->db->get_row($q, ARRAY_A);
	}

	function getTrackerByIdAndValue($id, $value) {
		$q = 'SELECT * FROM `'. $this->tableUrls .'` WHERE `id`='. intval($id) .' AND `url_value`="'. $value .'"';
		return $this->db->get_row($q, ARRAY_A);
	}

	function deleteTracker() {
		if ($_POST) {
			$id         = intval($_POST['id']);
			$tracker    = $this->getTrackerById($id);

			$q = 'DELETE FROM `'. $this->tableUrls .'` WHERE `id`='. intval($id);
			$this->db->query($q);

			$q2 = 'DELETE FROM `'. $this->dbPrefix .'posts` WHERE `guid`='. intval($id);
			$this->db->query($q2);


			die ('done');
		}
		die ('error');
	}

	function updateStatus() {
		if ($_POST) {
			$id = intval($_POST['id']);

			$tracker = $this->getTrackerById($id);
			if (0 != count($tracker)) {
				$status = ($tracker['status'] == CLICKVOODOO_ENABLED) ? CLICKVOODOO_DISABLED : CLICKVOODOO_ENABLED;

				$q = 'UPDATE `'. $this->tableUrls .'` SET `status`='. $status .' WHERE `id`='. intval($id);
				$this->db->query($q);
			}

			die ('done');
		}
		die ('error');
	}

	function resetClicks() {
		if ($_POST) {
			$id = intval($_POST['id']);

			$q = 'UPDATE `'. $this->tableUrls .'` SET `clicks`=0 WHERE `id`='. intval($id);
			$this->db->query($q);

			die ('done');
		}
		die ('error');
	}

	function updateTracker() {
		global $clickVoodooHelpers;

		if ($_POST) {
			//* do final checking here for the generated value before saving to db.
			//* if found a match, just generate a new one and save that into db.

			$id         = intval($_POST['id']);
			$name       = trim(strip_tags($_POST['name']));
			$url        = trim(strip_tags($_POST['url']));
			$value      = trim(strip_tags($_POST['value']));

			$modified   = strftime('%Y-%m-%d %T');
			$ip         = $_SERVER['REMOTE_ADDR'];


			if ($this->getTrackerByIdAndValue($id, $value)) {
				$q  = 'UPDATE `'. $this->tableUrls .'` SET `name`="'. $name .'", `url`="'. $url .'", `modified`="'. $modified .'", `ip`="'. $ip .'" WHERE `id`='. intval($id) .' AND `url_value`="'. $value .'"';
			}
			else {
				$q  = 'UPDATE `'. $this->tableUrls .'` SET `name`="'. $name .'", `url`="'. $url .'", `url_value`="'. $value .'", `modified`="'. $modified .'", `ip`="'. $ip .'" WHERE `id`='. intval($id);
			}
			$this->db->query($q);


			$post = array(
				'post_title'    => $name .' - created automatically by '. CLICKVOODOO_NAME .' : DO NOT DELETE',
				'post_name'     => $value
			);

			$q2 = 'UPDATE `'. $this->dbPrefix .'posts` SET `post_title`="'. $post['post_title'] .'", `post_name`="'. $post['post_name'] .'" WHERE `guid`='. intval($id);
			$this->db->query($q2);

			die ('done');
		}
		die ('error');
	}

	function updateClicksById($id, $clicks) {
		$q = 'UPDATE `'. $this->tableUrls .'` SET `clicks`='. intval($clicks) .' WHERE `id`='. intval($id);
		$this->db->query($q);
	}

	function updateSettings() {
		if ($_POST) {
			global $wp_rewrite;

			$urlParser  = trim(strip_tags($_POST['url_parser']));
			$options    = get_option($this->tableOptions);
			if (!is_array($options) || is_array($options)) {
				$values = array(
					'url_parser' => $urlParser
				);

				update_option($this->tableOptions, $values);
			}

			die ('done');
		}
		die ('error');
	}

	function validateTracker() {
		if ($_POST) {
			$value = trim(strip_tags($_POST['value']));

			$q = 'SELECT `post_name` FROM `' . $this->dbPrefix . 'posts` WHERE `post_name`="' . $value . '"';
			$res = $this->db->get_row($q, ARRAY_A);

			$q2 = 'SELECT * FROM `'. $this->tableUrls .'` WHERE `url_value`="'. $value .'"';
			$res2 = $this->db->get_row($q2, ARRAY_A);

			if (0 != count($res) || 0 != count($res2)) {
				die ('found');
			}

			die ('cleared');
		}
		die ('error');
	}

	function validateExistingTracker() {
		if ($_POST) {
			$id     = intval($_POST['id']);
			$value  = trim(strip_tags($_POST['value']));

//			$q = 'SELECT `post_name` FROM `'. $this->dbPrefix .'posts` WHERE `post_name`="'. $value .'"';
			$q = 'SELECT `post_name` FROM `'. $this->dbPrefix .'posts` WHERE `post_name`="'. $value .'" AND `guid` != '. intval($id);
			$res = $this->db->get_results($q, ARRAY_A);

			$q2 = 'SELECT * FROM `'. $this->tableUrls .'` WHERE `url_value`="'. $value .'"';
			$res2 = $this->db->get_row($q2, ARRAY_A);

			if (0 != count($res)) {
				die ('found');
			}

			if (0 != count($res2)) {
				if ($res2['id'] != $id) {
					die ('found');
				}
			}

			die ('cleared');
		}
		die ('error');
	}
}
